import { world, system, ItemStack } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:glow_root', {
        onPlayerDestroy({ block }) {
            const { x, y, z } = block.location
            if (block.above().typeId === 'v360:glow_root_body') {
                block.above().setType('v360:glow_root')
            }
        },
        onPlace({ block }) {
            const { x, y, z } = block.location
            if (block.above().typeId === 'v360:glow_root') {
                block.above().setType('v360:glow_root_body')
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:glow_vine', {
        onPlayerDestroy({ block }) {
            const { x, y, z } = block.location
            if (block.above().typeId === 'v360:glow_vine_body') {
                block.above().setType('v360:glow_vine')
            }
            if (block.above().typeId === 'v360:glow_vine_body_cherries') {
                block.above().setType('v360:glow_vine_head_cherries')
            }
        },
        onPlace({ block }) {
            const { x, y, z } = block.location
            if (block.above().typeId === 'v360:glow_vine') {
                block.above().setType('v360:glow_vine_body')
            }
            if (block.above().typeId === 'v360:glow_vine_head_cherries') {
                block.above().setType('v360:glow_vine_body_cherries')
            }
        },
        onPlayerInteract({ block }) {
            if (block.hasTag('v360:glow_vine_head')) {
                block.setType('v360:glow_vine')
                block.dimension.spawnItem(new ItemStack('v360:glow_cherries', 4), block.center())
                block.dimension.playSound('pick_berries.cave_vines', block.location)
            }
            if (block.hasTag('v360:glow_vine_body')) {
                block.setType('v360:glow_vine_body')
                block.dimension.spawnItem(new ItemStack('v360:glow_cherries', 2), block.center())
                block.dimension.playSound('pick_berries.cave_vines', block.location)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:glow_vine_body', {
        onRandomTick({ block }) {
            block.setType('v360:glow_vine_body_cherries')
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:glow_vine_head', {
        onRandomTick({ block }) {
            block.setType('v360:glow_vine_head_cherries')
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:glow_vine_head_no_cherries', {
        onRandomTick({ block }) {
            if (block.below().isAir) {
                block.setType('v360:glow_vine_body')
                block.below().setType('v360:glow_vine')
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:glow_vine_head_cherries', {
        onRandomTick({ block }) {
            if (block.below().isAir) {
                block.setType('v360:glow_vine_body_cherries')
                block.below().setType('v360:glow_vine')
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:glow_stalagmit', {
        onEntityFallOn({ block, entity }) {
            entity.applyDamage(4)
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:glow_nest', {
        onTick({ block }) {
            const { x, y, z } = block.location
            const random = Math.random
            block.dimension.runCommand(`setblock ${x} ${y} ${z} air [] destroy`)
            if (random <= 1 / 4) {
                block.dimension.spawnEntity('v360:glow_larva', block.center())
            }
            else if (random <= 2 / 4) {
                block.dimension.spawnEntity('v360:glow_larva', block.center())
                block.dimension.spawnEntity('v360:glow_larva', block.center())
            }
            else if (random <= 3 / 4) {
                block.dimension.spawnEntity('v360:glow_larva', block.center())
                block.dimension.spawnEntity('v360:glow_larva', block.center())
                block.dimension.spawnEntity('v360:glow_larva', block.center())
            }
            else {
                block.dimension.spawnEntity('v360:glow_larva', block.center())
                block.dimension.spawnEntity('v360:glow_larva', block.center())
                block.dimension.spawnEntity('v360:glow_larva', block.center())
                block.dimension.spawnEntity('v360:glow_larva', block.center())
            }
        },
        onPlayerDestroy({ block }) {
            const random = Math.random
            if (random <= 1 / 4) {
                block.dimension.spawnEntity('v360:glow_larva', block.center())
            }
            else if (random <= 2 / 4) {
                block.dimension.spawnEntity('v360:glow_larva', block.center())
                block.dimension.spawnEntity('v360:glow_larva', block.center())
            }
            else if (random <= 3 / 4) {
                block.dimension.spawnEntity('v360:glow_larva', block.center())
                block.dimension.spawnEntity('v360:glow_larva', block.center())
                block.dimension.spawnEntity('v360:glow_larva', block.center())
            }
            else {
                block.dimension.spawnEntity('v360:glow_larva', block.center())
                block.dimension.spawnEntity('v360:glow_larva', block.center())
                block.dimension.spawnEntity('v360:glow_larva', block.center())
                block.dimension.spawnEntity('v360:glow_larva', block.center())
            }
        }
    })
})